# Activar Game Mode en una app de macOS (edición local)

> **Resumen:** Vas a añadir dos claves al `Info.plist` para declarar la app como *Juegos* y marcarla como compatible con Game Mode, y después volver a firmarla ad‑hoc para que se ejecute localmente.

## Requisitos
- macOS Sonoma (14) o posterior.
- Terminal con permisos de administrador cuando sea necesario.
- Trabaja sobre **una copia** si no quieres modificar el original.

---

## Pasos rápidos
1) **(Opcional) Quitar cuarentena y/o hacer copia**  
```bash
cp -R "/Applications/Application.app" ~/Desktop/
xattr -dr com.apple.quarantine ~/Desktop/Application.app  # si la app está bloqueada
cd ~/Desktop
```

2) **Editar `Info.plist`**  
```bash
plutil -replace LSApplicationCategoryType -string "public.app-category.games"   "Application.app/Contents/Info.plist"

plutil -replace LSSupportsGameMode -bool true   "Application.app/Contents/Info.plist"
```

3) **Re-firmar ad‑hoc (uso local)**  
```bash
codesign -f -s - --deep --preserve-metadata=entitlements,requirements,flags   "Application.app"
```

4) **Abrir a pantalla completa** → Game Mode se activa durante la sesión.

---

## Verificaciones útiles
```bash
# Comprobar claves
plutil -p "Application.app/Contents/Info.plist" |   grep -E "LSApplicationCategoryType|LSSupportsGameMode"

# Ver firma y política de ejecución
codesign -dv --verbose=4 "Application.app"
spctl -a -vv "Application.app"
```

---

## Script automático
Si prefieres automatizar todo, usa el script: [`enable-game-mode.sh`](./enable-game-mode.sh).  
**Uso básico:**
```bash
chmod +x enable-game-mode.sh
./enable-game-mode.sh "/Applications/Application.app"
```
**Flags opcionales:**
- `--category <id>` para cambiar la categoría (por defecto: `public.app-category.games`).
- `--no-quarantine` para no tocar atributos de cuarentena.
- `--no-deep` para firmar sin `--deep` (no recomendado salvo bundles simples).

---

## Notas y advertencias
- Cualquier cambio en el bundle invalida la firma original. Re‑firmar con `-s -` (ad‑hoc) es suficiente para uso local, **no** para distribución.
- Si vas a distribuir la app, firma con **Developer ID** y **notariza** para evitar bloqueos de Gatekeeper.
- Algunas apps pueden dejar de auto‑actualizarse tras modificar el bundle.
